NAVSession.prototype.abortTransaction = function () {
    this.forwardToCustomFunction("sessionAbortTransaction");
};

NAVSession.prototype.advanceClusterTime = function (clusterTime) {
    this.forwardToCustomFunction("sessionAdvanceClusterTime", clusterTime);
};

NAVSession.prototype.advanceOperationTime = function (timestamp) {
    this.forwardToCustomFunction("sessionAdvanceOperationTime", timestamp);
};

NAVSession.prototype.commitTransaction = function () {
    this.forwardToCustomFunction("sessionCommitTransaction");
};

NAVSession.prototype.endSession = function () {
    this.forwardToCustomFunction("sessionEndSession");
};

NAVSession.prototype.getClusterTime = function () {
    return this.forwardToCustomFunction("sessionGetClusterTime");
};

NAVSession.prototype.getDatabase = function (databaseName) {
    if (isUndefined(databaseName))
        nav_throwError("mongo.getDB should have database name");
    if (!isString(databaseName))
        nav_throwError("database name should be string");

    return this.forwardToCustomFunction("sessionGetDatabase", databaseName);
};

NAVSession.prototype.getOperationTime = function () {
    return this.forwardToCustomFunction("sessionGetOperationTime");
};

NAVSession.prototype.getOptions = function () {
    return this.forwardToCustomFunction("sessionGetOptions");
};

NAVSession.prototype.hasEnded = function () {
    return this.forwardToCustomFunction("sessionHasEnded");
};

NAVSession.prototype.startTransaction = function (options) {
    var readConcern = options ? options.readConcern : undefined;
    var level = readConcern ? readConcern.level : undefined;

    var writeConcern = options ? options.writeConcern : undefined;

    this.forwardToCustomFunction("sessionStartTransaction", level, writeConcern);
};

// NAVSessionOptions
NAVSessionOptions.prototype.getReadConcern = function () {
    return this.forwardToCustomFunction("sessionOptionsGetReadConcern");
};

NAVSessionOptions.prototype.getReadPreference = function () {
    return this.forwardToCustomFunction("sessionOptionsGetReadPreference");
};

NAVSessionOptions.prototype.getWriteConcern = function () {
    return this.forwardToCustomFunction("sessionOptionsGetWriteConcern");
};

NAVSessionOptions.prototype.isCausalConsistency = function () {
    return this.forwardToCustomFunction("sessionOptionsIsCausalConsistency");
};

NAVSessionOptions.prototype.setReadConcern = function (readConcern) {
    var level = undefined;
    if (readConcern) {
        if (isString(readConcern))
            level = readConcern;
        else
            level = readConcern.level;
    }
    this.forwardToCustomFunction("sessionOptionsSetReadConcern", level);
};

NAVSessionOptions.prototype.setReadPreference = function (readPreference) {
    var mode = readPreference ? readPreference.mode : undefined;
    var tags = readPreference ? readPreference.tags : undefined;

    this.forwardToCustomFunction("sessionOptionsSetReadPreference", mode, tags);
};

NAVSessionOptions.prototype.setWriteConcern = function (writeConcern) {
    this.forwardToCustomFunction("sessionOptionsSetWriteConcern", writeConcern);
};

NAVSessionOptions.prototype.shouldRetryWrites = function () {
    return this.forwardToCustomFunction("sessionOptionsShouldRetryWrites");
};
